<?php
// Verificar se já está instalado
if (file_exists('config.php')) {
    // Verificar se o database.php foi configurado
    $db_content = @file_get_contents('database.php');
    if ($db_content && strpos($db_content, "'seu user aqui'") === false) {
        header('Location: login.php');
        exit;
    }
}

$erro = '';
$sucesso = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $host = $_POST['host'];
    $user = $_POST['user'];
    $pass = $_POST['pass'];
    $dbname = $_POST['dbname'];
    $recaptcha_site_key = $_POST['recaptcha_site_key'];
    $recaptcha_secret_key = $_POST['recaptcha_secret_key'];
    
    if (empty($host) || empty($user) || empty($dbname)) {
        $erro = "Servidor, usuário e nome do banco são obrigatórios!";
    } else {
        try {
            // Testar conexão MySQL
            $pdo = new PDO("mysql:host=$host", $user, $pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Criar banco
            $pdo->exec("CREATE DATABASE IF NOT EXISTS $dbname");
            $pdo->exec("USE $dbname");
            
            // Criar tabelas
            $pdo->exec("CREATE TABLE IF NOT EXISTS usuarios (
                id INT AUTO_INCREMENT PRIMARY KEY,
                nome VARCHAR(100) NOT NULL,
                email VARCHAR(100) NOT NULL UNIQUE,
                login VARCHAR(50) NOT NULL UNIQUE,
                senha VARCHAR(255) NOT NULL,
                tipo ENUM('admin','usuario') DEFAULT 'usuario',
                data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                ultimo_login DATETIME NULL,
                ativo BOOLEAN DEFAULT TRUE
            )");
            
            $pdo->exec("CREATE TABLE IF NOT EXISTS planos (
                id INT AUTO_INCREMENT PRIMARY KEY,
                usuario_id INT NOT NULL,
                nome VARCHAR(100) NOT NULL,
                tipo VARCHAR(50) NOT NULL,
                dias INT NOT NULL,
                valor DECIMAL(10,2) NOT NULL,
                creditos TEXT,
                data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )");
            
            $pdo->exec("CREATE TABLE IF NOT EXISTS servidores (
                id INT AUTO_INCREMENT PRIMARY KEY,
                usuario_id INT NOT NULL,
                nome VARCHAR(100) NOT NULL,
                tipo VARCHAR(50) NOT NULL,
                url VARCHAR(255) NOT NULL,
                status ENUM('ativo','inativo') DEFAULT 'ativo',
                data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )");
            
            $pdo->exec("CREATE TABLE IF NOT EXISTS clientes (
                id INT AUTO_INCREMENT PRIMARY KEY,
                usuario_id INT NOT NULL,
                nome VARCHAR(100) NOT NULL,
                telefone VARCHAR(20) NOT NULL,
                plano_id INT NOT NULL,
                servidor_id INT,
                data_vencimento DATE NOT NULL,
                observacoes TEXT,
                status ENUM('ativo','inativo','pendente') DEFAULT 'ativo',
                data_criacao TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )");
            
            $pdo->exec("CREATE TABLE IF NOT EXISTS security_logs (
                id INT AUTO_INCREMENT PRIMARY KEY,
                usuario_id INT NULL,
                acao VARCHAR(100) NOT NULL,
                ip_address VARCHAR(45) NOT NULL,
                user_agent TEXT,
                data_registro TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )");
            
            // Inserir usuário admin
            $senha_hash = password_hash('Admin@123456', PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT IGNORE INTO usuarios (nome, email, login, senha, tipo) VALUES (?,?,?,?,?)");
            $stmt->execute(['Administrador Gestor DREEYTV', 'admin@dreeytv.com', 'admin', $senha_hash, 'admin']);
            
            // Atualizar database.php
            $database_content = '<?php
function installDatabase() {
    $host = \'' . $host . '\';
    $user = \'' . $user . '\';
    $pass = \'' . $pass . '\';
    $dbname = \'' . $dbname . '\';
    
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        return $pdo;
    } catch (PDOException $e) {
        die("
        <!DOCTYPE html>
        <html>
        <head>
            <title>Erro de Conexão - Gestor DREEYTV</title>
            <style>
                body { font-family: Arial, sans-serif; max-width: 600px; margin: 100px auto; padding: 20px; }
                .error { background: #fee; border: 2px solid #f00; padding: 20px; border-radius: 10px; }
            </style>
        </head>
        <body>
            <div class=\'error\'>
                <h2>❌ Erro de Conexão - Gestor DREEYTV</h2>
                <p><strong>Erro:</strong> {$e->getMessage()}</p>
                <p>Verifique se o MySQL está rodando e as credenciais estão corretas.</p>
            </div>
        </body>
        </html>");
    }
}

$pdo = installDatabase();
?>';
            
            file_put_contents('database.php', $database_content);
            
            // Atualizar security.php
            $security_content = file_get_contents('security.php');
            $security_content = str_replace("'SUA CHAVE RECAPTCHA AQUI'", "'$recaptcha_secret_key'", $security_content);
            file_put_contents('security.php', $security_content);
            
            // Atualizar login.php
            $login_content = file_get_contents('login.php');
            $login_content = str_replace(' sua chave SITE KEY', $recaptcha_site_key, $login_content);
            file_put_contents('login.php', $login_content);
            
            $sucesso = "Sistema instalado com sucesso! Banco de dados criado e configurado.";
            
        } catch (PDOException $e) {
            $erro = "Erro no banco de dados: " . $e->getMessage();
        } catch (Exception $e) {
            $erro = "Erro geral: " . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalação - Gestor DREEYTV</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center; padding: 20px; }
        .install-container { background: white; padding: 40px; border-radius: 20px; box-shadow: 0 20px 40px rgba(0,0,0,0.1); width: 100%; max-width: 600px; }
        .logo { text-align: center; margin-bottom: 30px; }
        .logo h1 { font-size: 2.5rem; background: linear-gradient(135deg, #667eea, #764ba2); -webkit-background-clip: text; -webkit-text-fill-color: transparent; margin-bottom: 10px; }
        .form-group { margin-bottom: 20px; }
        .form-group label { display: block; margin-bottom: 8px; font-weight: 600; color: #333; }
        .form-control { width: 100%; padding: 15px; border: 2px solid #e1e5e9; border-radius: 10px; font-size: 16px; }
        .form-control:focus { border-color: #667eea; outline: none; box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1); }
        .btn { width: 100%; padding: 15px; background: linear-gradient(135deg, #667eea, #764ba2); color: white; border: none; border-radius: 10px; font-size: 16px; font-weight: 600; cursor: pointer; transition: all 0.3s; }
        .btn:hover { transform: translateY(-2px); box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3); }
        .alert { padding: 15px; border-radius: 10px; margin-bottom: 20px; }
        .alert-danger { background: #fee; border: 1px solid #fcc; color: #c00; }
        .alert-success { background: #efe; border: 1px solid #cfc; color: #0c0; }
        .info-box { background: #f8f9fa; padding: 20px; border-radius: 10px; margin-bottom: 20px; border-left: 4px solid #667eea; }
        .credentials { margin: 20px 0; padding: 15px; background: #f8f9fa; border-radius: 10px; }
    </style>
</head>
<body>
    <div class="install-container">
        <div class="logo">
            <h1>📺 GESTOR DREEYTV</h1>
            <p>Instalação do Sistema</p>
        </div>
        
        <?php if ($erro): ?>
            <div class="alert alert-danger">
                <strong>❌ Erro:</strong> <?php echo $erro; ?>
            </div>
        <?php endif; ?>
        
        <?php if ($sucesso): ?>
            <div class="alert alert-success">
                <strong>✅ Sucesso!</strong> <?php echo $sucesso; ?>
                <div class="credentials">
                    <h3>👑 Credenciais do Administrador</h3>
                    <p><strong>Usuário:</strong> admin</p>
                    <p><strong>Senha:</strong> Admin@123456</p>
                    <p style="color: #f56565; font-weight: 600; margin-top: 10px;">
                        ⚠️ Altere a senha após o primeiro login!
                    </p>
                </div>
                <div style="text-align: center; margin-top: 20px;">
                    <a href="login.php" class="btn" style="display: inline-block; width: auto; padding: 12px 30px;">🚀 Acessar Sistema</a>
                    <button onclick="deleteInstallFile()" class="btn" style="background: #f56565; display: inline-block; width: auto; padding: 12px 30px; margin-left: 10px;">🗑️ Remover Instalador</button>
                </div>
            </div>
        <?php else: ?>
        
        <div class="info-box">
            <h3>📋 Informações Necessárias</h3>
            <p>Preencha os dados do seu servidor MySQL abaixo:</p>
        </div>
        
        <form method="POST">
            <div class="form-group">
                <label for="host">🌐 Servidor MySQL</label>
                <input type="text" id="host" name="host" class="form-control" value="localhost" required>
            </div>
            
            <div class="form-group">
                <label for="user">👤 Usuário MySQL</label>
                <input type="text" id="user" name="user" class="form-control" placeholder="root" required>
            </div>
            
            <div class="form-group">
                <label for="pass">🔑 Senha MySQL</label>
                <input type="password" id="pass" name="pass" class="form-control" placeholder="Sua senha do MySQL">
            </div>
            
            <div class="form-group">
                <label for="dbname">🗃️ Nome do Banco</label>
                <input type="text" id="dbname" name="dbname" class="form-control" placeholder="gestor_dreeytv" required>
            </div>
            
            <div class="form-group">
                <label for="recaptcha_site_key">🔒 reCAPTCHA Site Key</label>
                <input type="text" id="recaptcha_site_key" name="recaptcha_site_key" class="form-control" placeholder="Sua chave do site reCAPTCHA">
            </div>
            
            <div class="form-group">
                <label for="recaptcha_secret_key">🔑 reCAPTCHA Secret Key</label>
                <input type="text" id="recaptcha_secret_key" name="recaptcha_secret_key" class="form-control" placeholder="Sua chave secreta reCAPTCHA">
            </div>
            
            <button type="submit" class="btn">🚀 Instalar Sistema</button>
        </form>
        
        <?php endif; ?>
    </div>

    <script>
        function deleteInstallFile() {
            if (confirm('⚠️ Tem certeza que deseja remover o arquivo de instalação?\n\nEsta ação não pode ser desfeita!')) {
                fetch('delete_install.php')
                    .then(response => response.text())
                    .then(data => {
                        alert('Arquivo de instalação removido com sucesso!');
                        document.querySelector('.alert-success').innerHTML += '<div style="margin-top: 15px; padding: 10px; background: #d4edda; border-radius: 5px;">✅ Arquivo de instalação removido!</div>';
                    })
                    .catch(error => {
                        alert('Erro ao remover arquivo: ' + error);
                    });
            }
        }
    </script>
</body>
</html>